module net.BurtonRadons.dedit.findCommands;

import net.BurtonRadons.dedit.main;
import net.BurtonRadons.dig.main;
import std.ctype;
import std.string;

class RunFind : Frame
{
    static bit matchWordGlobal;
    static bit matchCaseGlobal;
    static bit searchAllGlobal;
    static bit downGlobal = true;

    bit matchWord;
    bit matchCase;
    bit searchAll;
    bit wrap = true;
    bit down = true;

    View view;
    Button findButton;
    CheckBox matchWordCheckbox;
    CheckBox matchCaseCheckbox;
    CheckBox searchAllCheckbox;
    EditText searchString;
    char [] searchType = null; /**< The valid highlighting types, empty for any. */

    void searchTypeAll () { searchType = null; }
    void searchTypeComments () { searchType = "*"; }
    void searchTypeNonComments () { searchType = "#\"imrs\0"; }
    void searchTypeIdentifiers () { searchType = "\0im"; }
    void searchTypeStrings () { searchType = "\""; }
    
    this (View view)
    {
        Pane pane, pane2;

        matchWord = matchWordGlobal;
        matchCase = matchCaseGlobal;
        searchAll = searchAllGlobal;
        down = downGlobal;

        this.view = view;

        super ();
        caption ("Find");
        resizable (false);
        bind ("Escape", &doCancel);

        with (pane = new Pane (this))
            grid (0, 0);

        with (new Label (pane))
        {
            grid (0, 0);
            caption ("Fi&nd what:");
        }

        with (searchString = new EditText (pane))
        {
            grid (1, 0);
            sticky ("<>");
            bind ("Return", &doFind);
        }

        with (pane2 = new Pane (pane))
            grid (0, 1, 2, 1);

        int r = 0;

        with (matchWordCheckbox = new CheckBox (pane2))
        {
            gridAddRow (0, r, 2, 1);
            caption ("Match &whole word only");
            onClick.add (&doMatchWord);
            checked (matchWord);
        }

        with (matchCaseCheckbox = new CheckBox (pane2))
        {
            gridAddRow (0, r, 2, 1);
            caption ("Match &case");
            onClick.add (&doMatchCase);
            checked (matchCase);
        }

        with (searchAllCheckbox = new CheckBox (pane2))
        {
            gridAddRow (0, r, 2, 1);
            caption ("Search &all project files");
            onClick.add (&doSearchAll);
            checked (searchAll);
        }
        
        with (new Label (pane2))
        {
            caption ("Type:");
            grid (0, r);
        }
        
        searchType = null;
        with (new ComboBox (pane2))
        {
            gridAddRow (1, r);
            add ("all", "All", &searchTypeAll);
            add ("Comments Only", &searchTypeComments);
            add ("Non-Comments Only", &searchTypeNonComments);
            add ("Identifiers Only", &searchTypeIdentifiers);
            add ("Strings Only", &searchTypeStrings);
            current ("all");
            sticky ("<>");
        }

        GroupBox box;

        with (box = new GroupBox (pane2))
        {
            grid (2, 0, 1, r);
            caption ("Direction");
            sticky (">^");
        }

        RadioGroup group;
        RadioButton radio;

        with (group = new RadioGroup ())
        {
            value (1);
            set = &setDirection;
        }

        with (radio = new RadioButton (box))
        {
            grid (0, 0);
            caption ("&Up");
            group.add (radio, 0);
        }

        with (radio = new RadioButton (box))
        {
            grid (0, 1);
            caption ("&Down");
            group.add (radio, 1);
        }

        with (pane = new Pane (this))
        {
            grid (1, 0);
            sticky ("^v");
        }

        with (findButton = new Button (pane))
        {
            grid (0, 0);
            caption ("&Find First");
            sticky ("<>");
            onClick.add (&doFind);
            bind ("Return", &onClick);
        }

        with (new Button (pane))
        {
            grid (0, 1);
            caption ("&List Matches");
            sticky ("<>");
            onClick.add (&doListMatches);
        }

        with (new Button (pane))
        {
            grid (0, 2);
            caption ("Cancel");
            sticky ("<>v");
            onClick.add (&doCancel);
            bind ("Escape", &onClick);
        }

        display ();
        searchString.makeFocus ();
    }

    void setDirection (int value) { down = downGlobal = (bit) value; }
    
    bit searchTypeMatch (char high)
    {
        if (searchType === null)
            return true;
        for (int c; c < searchType.length; c ++)
            if (searchType [c] == high)
                return true;
        return false;
    }
    
    bit searchTypeMatch (char [] high)
    {
        for (int c; c < high.length; c ++)
            if (!searchTypeMatch (high [c]))
                return false;
        return true;
    }

    bit findLine (View view, Document document, int c, char [] search,
        inout int startLine, inout int startOffset, inout int endLine, inout int endOffset)
    {
        char [] [] lines = document.lines;
        char [] base = lines [c];
        int start = (c == startLine) ? imin (base.length, startOffset + 1) : 0;
        char [] line;
        int offset;

    restart:
        line = base [start .. lines [c].length];

        if (matchCase)
        {
            offset = std.string.find (line, search);
            if (offset < 0)
                return false;
        }
        else
        {
            for (offset = 0; ; offset ++)
                if (offset > line.length - search.length)
                    return false;
                else if (!icmp (line [offset .. offset + search.length], search))
                    break;
        }
        
        if (searchType)
        {
            char [] high;
            
            document.cleanLine (c);
            high = document.highs [c] [start .. document.highs [c].length];
            
            if (!searchTypeMatch (high [offset .. offset + search.length]))
            {
                start += offset + 1;
                goto restart;
            }
        }

        if (matchWord)
        {
            if (start + offset && std.ctype.isalnum (base [start + offset - 1]))
            {
                start += offset + 1;
                goto restart;
            }

            if (start + offset + search.length < base.length
             && std.ctype.isalnum (base [start + offset + search.length]))
            {
                start += offset + 1;
                goto restart;
            }
        }

        startLine = c;
        startOffset = offset + start;
        endLine = c;
        endOffset = offset + start + search.length;
        return true;
    }

    bit findAction (View view, Document document,
        inout int line, inout int offset,
        out int endLine, out int endOffset)
    {
        char [] search = searchString.text ();

        line = imid (0, line, document.lines.length);

        if (down || !wrap)
        {
            while (1)
            {
                char [] [] lines = document.lines;

                for (int c = line; c < lines.length; c ++)
                    if (findLine (view, document, c, search, line, offset, endLine, endOffset))
                        return true;

                if (!wrap)
                    return false;

                for (int c = 0; c < line; c ++)
                    if (findLine (view, document, c, search, line, offset, endLine, endOffset))
                    {
                        global.statusBar.display ("Passed the end of the file");
                        return true;
                    }

                break;
            }
        }
        else
        {
            while (1)
            {
                char [] [] lines = document.lines;

                for (int c = line; c >= 0; c --)
                    if (findLine (view, document, c, search, line, offset, endLine, endOffset))
                        return true;

                if (!wrap)
                    return false;

                for (int c = lines.length - 1; c > line; c --)
                    if (findLine (view, document, c, search, line, offset, endLine, endOffset))
                    {
                        global.statusBar.display ("Passed the end of the file");
                        return true;
                    }

                break;
            }
        }

        return false;
    }

    void doFind ()
    {
        char [] search = searchString.text ();

        if (!search.length)
            return;

        view.find = &findAction;
        wrap = true;

        Document d = view.document;

        int startLine = d.line, startOffset = d.offset;

        if (!findAction (view, d, startLine, startOffset, d.selEndLine, d.selEndOffset))
        {
            int c, r;
            
            gridExtents (c, r);

            with (new Label (this))
            {
                grid (0, r, c, 1);
                border (0, 0);
                caption (fmt ("Could not find \"%.*s\".", search));
            }
            
            display ();
        }
        else
        {
            d.line = d.selStartLine = startLine;
            d.offset = d.selStartOffset = startOffset;
            hide ();
            view.caretChange ();
        }
    }

    void doListMatches ()
    {
        char [] search = searchString.text ();
        MatchList list = new MatchList ();
        
        if (!search.length)
            return;

        int startLine, startOffset, endLine, endOffset;
        Document doc = view.document;

        if (!findAction (view, doc, startLine, startOffset, endLine, endOffset))
        {
            int c, r;
            gridExtents (c, r);

            with (new Label (this))
            {
                grid (0, r, c, 1);
                border (0, 0);
                caption (fmt ("Could not find \"%.*s\".", search));
            }

            return;
        }

        hide ();
        wrap = false;

        while (1)
        {
            list.add (doc, startLine, doc.lines [startLine], startOffset, startOffset);
            if (!findAction (view, doc, startLine, startOffset, endLine, endOffset))
                break;
        }

        if (searchAll)
        {
            Document start = doc;

            for (int c; c < view.documents.length; c ++)
            {
                doc = view.documents [c];
                if (doc === start)
                    continue;
                startLine = startOffset = 0;
                while (1)
                {
                    if (!findAction (view, doc, startLine, startOffset, endLine, endOffset))
                        break;
                    list.add (doc, startLine, doc.lines [startLine], startOffset, startOffset);
                }
            }
        }

        list.display ();
    }

    void doCancel ()
    {
        hide ();
    }

    void doMatchWord ()
    {
        matchWord = !matchWord;
        matchWordGlobal = matchWord;
        matchWordCheckbox.checked (matchWord);
    }

    void doMatchCase ()
    {
        matchCase = !matchCase;
        matchCaseGlobal = matchCase;
        matchCaseCheckbox.checked (matchCase);
    }

    void doSearchAll ()
    {
        searchAll = !searchAll;
        searchAllGlobal = searchAll;
        searchAllCheckbox.checked (searchAll);
    }
}

/* Provides Find, Find and Replace, and various such. */

class FindCommands
{
    this ()
    {
        alias View.addCommand e;

        e ("Find", ".", &Find,
            "Search files for text.",
            "Show a dialog that will search files for text.");
        e ("FindNext", "", &FindNext,
            "Search for the next match.",
            "Continue the previous search and find the next "
            "match.");
    }

    static this ()
    {
        new FindCommands ();
    }

    void Find (View view)
    {
        new RunFind (view);
    }

    void FindNext (View view)
    {
        Document doc = view.document;

        if (view.find (view, doc, doc.line, doc.offset, doc.selEndLine, doc.selEndOffset))
        {
            doc.selStartLine = doc.line;
            doc.selStartOffset = doc.offset;
            view.caretChange ();
        }
    }
}
